//================================================\\
//| Author: WCCC                                 |\\
//| Title: Crafting Anvil                        |\\
//| Function: Turns metals into weapons!!!       |\\
//================================================\\

class CraftingAnvil extends Gadgets;

var travel byte XMode;
var travel byte bdrained;
var localized String msgMetalsAdded;
var() int MetalAmount;
//var byte XMode;

#exec OBJ LOAD FILE=CoreTexMetal

#exec MESH IMPORT MESH=Anvil ANIVFILE=C:\DeusEx\MODELS\Anvil_a.3d DATAFILE=C:\DeusEx\MODELS\Anvil_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Anvil X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Anvil SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Anvil SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=Anvil MESH=Anvil
#exec MESHMAP SCALE MESHMAP=Anvil X=.9 Y=.9 Z=.9

#exec MESHMAP SETTEXTURE MESHMAP=Anvil NUM=1 TEXTURE=ClenGrayMetal_B

function Fire( float Value )
{
       local MarkusGrayMale P;

  P = MarkusGrayMale(Owner);
  P.ClientMessage("you currently have "$P.Metals$" metals on you.");
}

auto state Pickup
{
	function Frob(Actor Frobber, Inventory frobWith)
	{
		local MarkusGrayMale player;

		Super.Frob(Frobber, frobWith);

		player = MarkusGrayMale(Frobber);

		if (player != None)
		{
			if (bdrained == 0)
                        {
			player.Metals += MetalAmount;
			player.ClientMessage(Sprintf(msgMetalsAdded, MetalAmount));
			player.FrobTarget = None;
			bDrained = 1;
                        }
			else if (bdrained == 1)
			{
			player.FrobTarget = None;
			}
		}
	}
}

function ScopeToggle()
{
         local MarkusGrayMale P;
	 local Inventory Copy;

  P = MarkusGrayMale(Owner);
  if (XMode == 0)
  {
    XMode = 1;
    P.ClientMessage("Now forging USP's");
    return;
  }
  if (XMode == 1)
  {
      XMode = 2;
      P.ClientMessage("Now forging Berettas");
      return;
  }
  if (XMode == 2)
  {
    XMode = 3;
    P.ClientMessage("Now forging Deagles");
    return;
  }
  if (XMode == 3)
  {
    XMode = 4;
    P.ClientMessage("Now forging Hunting Crossbows");
    return;
  }
  if (XMode == 4)
  {
    XMode = 5;
    P.ClientMessage("Now forging Omnni Crossbows");
    return;
  }
  if (XMode == 5)
  {
    XMode = 6;
    P.ClientMessage("Now forging Sawed Offs");
    return;
  }
  if (XMode == 6)
  {
    XMode = 7;
    P.ClientMessage("Now forging SPAS-12's");
    return;
  }
  if (XMode == 7)
  {
    XMode = 8;
    P.ClientMessage("Now forging Tactical Shotguns");
    return;
  }
  if (XMode == 8)
  {
    XMode = 9;
    P.ClientMessage("Now forging TST's");
    return;
  }
  if (XMode == 9)
  {
    XMode = 10;
    P.ClientMessage("Now forging RPGs");
    return;
  }
  if (XMode == 10)
  {
    XMode = 11;
    P.ClientMessage("Now forging M-95 barretts");
    return;
  }
  if (XMode == 11)
  {
    XMode = 12;
    P.ClientMessage("Now forging M-16's");
    return;
  }
  if (XMode == 12)
  {
    XMode = 13;
    P.ClientMessage("Now forging AK-47's");
    return;
  }
  if (XMode == 13)
  {
    XMode = 14;
    P.ClientMessage("Now forging Swords");
    return;
  }
  if (XMode == 14)
  {
    XMode = 15;
    P.ClientMessage("Now forging Daggers");
    return;
  }
  if (XMode == 15)
  {
    XMode = 0;
    P.ClientMessage("Now forging USP MATCH's");
    return;
  }
}

function LaserToggle()
{
       local MarkusGrayMale P;

  if (XMode == 0)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 120)
    {
    Spawn(class'Markistan.WeaponUSPMATCH',,,P.Location);
    P.Metals += -120;
    P.ClientMessage("120 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 120)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 1)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 180)
    {
    Spawn(class'Markistan.WeaponUSP',,,P.Location);
    P.Metals += -180;
    P.ClientMessage("180 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 180)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 2)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 90)
    {
    Spawn(class'Markistan.WeaponBeretta',,,P.Location);
    P.Metals += -90;
    P.ClientMessage("90 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 90)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 3)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 250)
    {
    Spawn(class'Markistan.WeaponDeagle',,,P.Location);
    P.Metals += -250;
    P.ClientMessage("250 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 250)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 4)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 250)
    {
    Spawn(class'Markistan.WeaponHuntingCrossbow',,,P.Location);
    P.Metals += -250;
    P.ClientMessage("250 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 250)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 5)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 350)
    {
    Spawn(class'Markistan.WeaponCrossbow',,,P.Location);
    P.Metals += -350;
    P.ClientMessage("350 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 350)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 6)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 350)
    {
    Spawn(class'Markistan.WeaponSawedOff',,,P.Location);
    P.Metals += -350;
    P.ClientMessage("350 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 350)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 7)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 350)
    {
    Spawn(class'Markistan.WeaponSPAS12',,,P.Location);
    P.Metals += -350;
    P.ClientMessage("350 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 350)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 8)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 400)
    {
    Spawn(class'Markistan.WeaponTacticalShotgun',,,P.Location);
    P.Metals += -400;
    P.ClientMessage("400 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 400)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 9)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 500)
    {
    Spawn(class'Markistan.WeaponTST',,,P.Location);
    P.Metals += -500;
    P.ClientMessage("500 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 500)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 10)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 900)
    {
    Spawn(class'Markistan.WeaponRPG',,,P.Location);
    P.Metals += -900;
    P.ClientMessage("900 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 900)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 11)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 750)
    {
    Spawn(class'Markistan.WeaponBarrett',,,P.Location);
    P.Metals += -750;
    P.ClientMessage("750 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 750)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 12)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 150)
    {
    Spawn(class'Markistan.WeaponM16',,,P.Location);
    P.Metals += -150;
    P.ClientMessage("150 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 150)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 13)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 400)
    {
    Spawn(class'Markistan.WeaponAK47',,,P.Location);
    P.Metals += -400;
    P.ClientMessage("400 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 400)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 14)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 120)
    {
    Spawn(class'DeusEx.WeaponSword',,,P.Location);
    P.Metals += -120;
    P.ClientMessage("120 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 120)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
  if (XMode == 15)
  {
  P = MarkusGrayMale(Owner);
  if (P.Metals >= 100)
    {
    Spawn(class'Markistan.WeaponDagger',,,P.Location);
    P.Metals += -100;
    P.ClientMessage("100 metals used, succesful construction. "$P.Metals$" remaining.");
    }
  else if (P.Metals < 100)
   {
    P.ClientMessage("|p2Insufficient Metals.");
   }
  }
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 6);
    }

defaultproperties
{
     msgMetalsAdded="%d metals added"
     NoiseLevel=0.000000
     EnviroEffective=ENVEFF_Air
     ShotTime=0.000000
     reloadTime=0.000000
     HitDamage=0
     maxRange=128
     AccurateRange=128
     bHasScope=True
     bHasLaser=True
     bInstantHit=True
     InventoryGroup=185
     ItemName="Crafting Anvil"
     PlayerViewOffset=(Z=-12.000000)
     PlayerViewMesh=LodMesh'Markistan.Anvil'
     PickupViewMesh=LodMesh'Markistan.Anvil'
     ThirdPersonMesh=LodMesh'Markistan.Anvil'
     Icon=Texture'Markistan.Icons.BeltIconAnvil'
     Description="A medieval anvil that has seen much action, with enough metals and knowledge you can craft weapons! Simply get the right book, check your supplies (fire button), set it to what you want (scope toggle button), and hit the craft button (laser toggle)."
     beltDescription="FORGE"
     Mesh=LodMesh'Markistan.Anvil'
     CollisionRadius=5.500000
     CollisionHeight=3.700000
}
